function MAPSMALL = rasterupscale2( MAP, slipsurfacevalue )
% Downsamples a raster representing a fault zone by a factor 10. It makes
% sure that the thin slip surfaces are not lost, by always including pixels
% with the slip surface value. For other pixels the mode is used.
% 
% Yannick Kremer 2011

height = floor( size(MAP,1) * .5 );
width =  floor( size(MAP,2) * .5 );

MAPSMALL = nan( height, width );

for x = 1 : width-1,
    for y = 1: height-1,
        
        block = double( MAP( ( y*2 - 1 ) : ( y*2 ),  (x*2 - 1) : ( x*2) ) );
        
        if any( block(:) == slipsurfacevalue ),
            upscaled = slipsurfacevalue;
        else
            upscaled = mode( block(:) );
        end
           
        MAPSMALL( y, x ) = upscaled;
    end
end

